# flake8: noqa E741
from PySide2.QtCore import Qt

from moderngl_window.context.base import BaseKeys


class Keys(BaseKeys):
    """
    Namespace mapping pyside2 specific key constants
    """

    ESCAPE = Qt.Key_Escape
    SPACE = Qt.Key_Space
    ENTER = Qt.Key_Enter
    PAGE_UP = Qt.Key_PageUp
    PAGE_DOWN = Qt.Key_PageDown
    LEFT = Qt.Key_Left
    RIGHT = Qt.Key_Right
    UP = Qt.Key_Up
    DOWN = Qt.Key_Down

    TAB = Qt.Key_Tab
    COMMA = Qt.Key_Comma
    MINUS = Qt.Key_Minus
    PERIOD = Qt.Key_Period
    SLASH = Qt.Key_Slash
    SEMICOLON = Qt.Key_Semicolon
    EQUAL = Qt.Key_Equal
    LEFT_BRACKET = Qt.Key_BracketLeft
    RIGHT_BRACKET = Qt.Key_BracketRight
    BACKSLASH = Qt.Key_Backslash
    BACKSPACE = Qt.Key_Backspace
    INSERT = Qt.Key_Insert
    DELETE = Qt.Key_Delete
    HOME = Qt.Key_Home
    END = Qt.Key_End
    CAPS_LOCK = Qt.Key_CapsLock

    F1 = Qt.Key_F1
    F2 = Qt.Key_F2
    F3 = Qt.Key_F3
    F4 = Qt.Key_F4
    F5 = Qt.Key_F5
    F6 = Qt.Key_F6
    F7 = Qt.Key_F7
    F8 = Qt.Key_F8
    F9 = Qt.Key_F9
    F10 = Qt.Key_F10
    F11 = Qt.Key_F11
    F12 = Qt.Key_F12

    NUMBER_0 = Qt.Key_0
    NUMBER_1 = Qt.Key_1
    NUMBER_2 = Qt.Key_2
    NUMBER_3 = Qt.Key_3
    NUMBER_4 = Qt.Key_4
    NUMBER_5 = Qt.Key_5
    NUMBER_6 = Qt.Key_6
    NUMBER_7 = Qt.Key_7
    NUMBER_8 = Qt.Key_8
    NUMBER_9 = Qt.Key_9

    # Uses a modifier for numpad. We just repeat the numbers for compatibility
    NUMPAD_0 = Qt.Key_0
    NUMPAD_1 = Qt.Key_1
    NUMPAD_2 = Qt.Key_2
    NUMPAD_3 = Qt.Key_3
    NUMPAD_4 = Qt.Key_4
    NUMPAD_5 = Qt.Key_5
    NUMPAD_6 = Qt.Key_6
    NUMPAD_7 = Qt.Key_7
    NUMPAD_8 = Qt.Key_8
    NUMPAD_9 = Qt.Key_9

    A = Qt.Key_A
    B = Qt.Key_B
    C = Qt.Key_C
    D = Qt.Key_D
    E = Qt.Key_E
    F = Qt.Key_F
    G = Qt.Key_G
    H = Qt.Key_H
    I = Qt.Key_I
    J = Qt.Key_J
    K = Qt.Key_K
    L = Qt.Key_L
    M = Qt.Key_M
    N = Qt.Key_N
    O = Qt.Key_O
    P = Qt.Key_P
    Q = Qt.Key_Q
    R = Qt.Key_R
    S = Qt.Key_S
    T = Qt.Key_T
    U = Qt.Key_U
    V = Qt.Key_V
    W = Qt.Key_W
    X = Qt.Key_X
    Y = Qt.Key_Y
    Z = Qt.Key_Z
