# FreeIPA Code of Conduct

Our community is made up of a mixture of contributors from all over the world.
We are diverse in our background, expertise or opinions and it is our strength,
but diversity can also lead to communication issues and unhappiness. To that
end, we have a few ground rules that we ask people to adhere to when operating
in our space.

If you believe someone is violating the code of conduct, we ask that you report
it by emailing conduct@mg.freeipa.org.

This isn’t an exhaustive list of things that you can’t do. Rather, take it in
the spirit in which it’s intended - a guide to make it easier to be excellent to
each other:

### Be friendly and patient.

### Be welcoming.
We strive to be a community that welcomes and supports people of all backgrounds
and identities. This includes, but is not limited to members of any race,
ethnicity, culture, national origin, colour, immigration status, social and
economic class, educational level, sex, sexual orientation, gender identity and
expression, age, size, family status, political belief, religion, and mental and
physical ability.

### Be considerate. 
Your work will be used by other people, and you in turn will depend on the work
of others. Any decision you take will affect users and colleagues, and you
should take those consequences into account when making decisions. Remember that
we're a world-wide community, so you might not be communicating in someone
else's primary language.

### Be respectful.
Not all of us will agree all the time, but disagreement is no excuse for poor
behavior and poor manners. We might all experience some frustration now and
then, but we cannot allow that frustration to turn into a personal attack. It’s
important to remember that a community where people feel uncomfortable or
threatened is not a productive one. Members of the community should be
respectful when dealing with other members as well as with people outside the
community. Success comes from the team and the ability of team members to work
together. Members have differents skills, talents and roles but each of them is
important to the team and the final success. Think of the team first.

### Be careful in the words that you choose. 
We are a community of professionals, and we conduct ourselves professionally. Be
kind to others. Do not insult or put down other participants. Harassment and
other exclusionary behavior aren't acceptable. This includes, but is not limited
to:
* Violent threats or language directed against another person.
* Discriminatory jokes and language.
* Posting sexually explicit or violent material.
* Posting (or threatening to post) other people's personally identifying
  information ("doxing").
* Personal insults, especially those using racist or sexist terms.
* Unwelcome sexual attention.
* Advocating for, or encouraging, any of the above behavior.
* Repeated harassment of others. In general, if someone asks you to stop,
  then stop.

### When we disagree, try to understand why. 
Disagreements, both social and technical, happen all the time and our community
is no exception. It is important that we resolve disagreements and differing
views constructively. Remember that we’re different. The strength of community
comes from its diversity, people from a wide range of backgrounds. Different
people have different perspectives on issues. Being unable to understand why
someone holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that it
is human to err and blaming each other doesn’t get us anywhere. Give people the
benefit of the doubt, instead of blaming someone and pointing fingers. Speak
with them and try to understand what happened. Focus on helping to resolve
issues and learning from mistakes.

### Drive your emotions and create a safe place for others.
We aren’t robots, we are people with feelings. Feelings are a great
gift. Unfortunately that gift can betray us sometimes and let our common sense
to be driven by assumptions, expectations, anger, … To prevent and get away from
this situation is always better to start with facts, then mention the personal
story - your story - what are the concerns, objections, experience, and maybe
observations.

### Listen and hear, ask and don’t assume.
There is always something behind. If you are not sure, feel free to ask for more
information like “I don’t fully understand this…, could you help me to
understand that part please?”
* “So you are saying ..., is that right?”
* “I have different opinion here but I would like to know more about the
  solution you’re proposing.”
* “I have concerns about this solution because of A, B, C risks. What could be
  the prevention in your solution if we get into that situation?”

### You will never be wrong when saying “please” and “thank you”

## Scope
This Code of Conduct applies both within project spaces and in public spaces
when an individual is engaging with the project or its community.  Examples of
engagement includes communication on IRC, bugtrackers, social media, and the
like, or official presence as a project representative at an online or offline
event. Representation of a project may be further defined and clarified by
project maintainers.

## Enforcement
Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at conduct@mg.freeipa.org. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an
incident.  Further details of specific enforcement policies may be posted
separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

The idea behind the "enforcement" is not throwing it to each other publicly. If
the violation is not severe, it is expected that the people involved in the
situation could have a private and mature talk about the violation itself. Since
it may happen that people violate the Code of Conduct without realizing they are
violating it.

A strategy for such talk could be:
1. Call people up, instead of calling them out. (Shame rarely helps.)
2. Demonstrate good behavior.
3. Provide a positive intention.
4. Focus on the problem, not the person,
5. Point to guidelines or the impact, rather than individual.

Original text courtesy of the [Django project](djangoproject.com/conduct/).
"Scope" and "Enforcement" section courtesy of the [Contributor Covenant](https://www.contributor-covenant.org/).
A strategy for a talk about a violation is based on Rebecca Fernandez DevConf.cz 2018 talk: "Power of One".
