/** @file
  Google Test mocks for SafeIntLib

  Copyright (c) Microsoft Corporation.
  SPDX-License-Identifier: BSD-2-Clause-Patent
**/

#include <GoogleTest/Library/MockSafeIntLib.h>

MOCK_INTERFACE_DEFINITION (MockSafeIntLib);

MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8ToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8ToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8ToUint32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8ToUintn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8ToUint64, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint8ToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint8ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16ToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16ToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16ToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16ToUint32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16ToUintn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16ToUint64, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint16ToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint16ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint16ToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint16ToInt16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToInt16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToUint32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToUintn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32ToUint64, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32ToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32ToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32ToInt16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32ToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32ToInt32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32ToIntn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToInt16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToInt32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToUint32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToUintn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnToUint64, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToInt16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToInt32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToUint32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToIntn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnToInt64, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToInt16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToInt32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToUint32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToIntn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToUintn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64ToUint64, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToInt8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToChar8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToUint8, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToInt16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToUint16, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToInt32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToUint32, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToIntn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToUintn, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64ToInt64, 2, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint8Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint16Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnAdd, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint8Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint16Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnSub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint8Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint16Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint32Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUintnMult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeUint64Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeChar8Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnAdd, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64Add, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeChar8Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnSub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64Sub, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt8Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeChar8Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt16Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt32Mult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeIntnMult, 3, EFIAPI);
MOCK_FUNCTION_DEFINITION (MockSafeIntLib, SafeInt64Mult, 3, EFIAPI);
